<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_payments', function (Blueprint $table){
            $table->bigIncrements('id');
            $table->string('order_id');
            $table->unsignedBigInteger('invoice_id');
            $table->string('currency');
            $table->float('amount');
            $table->string('txn_id');
            $table->string('payment_type');
            $table->string('payment_status');
            $table->string('receipt');
            $table->unsignedBigInteger('client_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_payments');
    }
}
