<?php

namespace Database\Seeders;

use App\Models\Template;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AiTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $template = [
            [
                'template_name'=>'subject',
                'prompt'=>"generate contract subject for this contract description ##description##",
                'module'=>'contract',
                'field_json'=>'{"field":[{"label":"Proposal Description","placeholder":"e.g. Terms and Conditions","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'description',
                'prompt'=>"generate contract description for this contract subject as follows ##subject##",
                'module'=>'contract',
                'field_json'=>'{"field":[{"label":"Contract Subject","placeholder":"e.g. Legal Protection,Terms and Conditions","field_type":"textarea","field_name":"subject"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'name',
                'prompt'=>"What would be the project name for decription as follows ##description##" ,
                'module'=>'project',
                'field_json'=>'{"field":[{"label":"Project Description","placeholder":"e.g. Efficiency and Optimization,Business Growth and Expansion","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'title',
                'prompt'=>"Generate a task name for a project in an ##project_name##, specifically related to ##instruction##.",
                'module'=>'task',
                'field_json'=>'{"field":[{"label":"Task name","placeholder":"e.g.Solving Problems","field_type":"text_box","field_name":"project_name"},{"label":"Task Instruction","placeholder":"e.g.Data Analysis","field_type":"textarea","field_name":"instruction"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'title',
                'prompt'=>"Generate a milestone name for a ##project_name##,specifically related to ##instruction##.",
                'module'=>'milestone',
                'field_json'=>'{"field":[{"label":"Milestone Description","placeholder":"e.g.Design Approved","field_type":"textarea","field_name":"project_name"},{"label":" Instruction","placeholder":"e.g. incorporated feedback and revisions","field_type":"textarea","field_name":"instruction"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'title',
                'prompt'=>"You are a software developer working on a platform or service, and you're experiencing a bug where ##description##. You need to come up with a descriptive bug title for this issue. Please generate a few bug titles that could be used to report this problem.",
                'module'=>'bug',
                'field_json'=>'{"field":[{"label":"Description of Bug","placeholder":"e.g.identify bugs and issues","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'title',
                'prompt'=>"Generate a list of Zoom meeting topics for ##description## metting. The purpose of the meeting is to  ##description##. Structure the topics to ensure a productive discussion.",
                'module'=>'zoom meeting',
                'field_json'=>'{"field":[{"label":"Meeting description ","placeholder":"e.g.Remote Collaboration","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'name',
                'prompt'=>"please suggest subscription plan name for my business of the description as follows  ##description##",
                'module'=>'plan',
                'field_json'=>'{"field":[{"label":"What is your plan about?","placeholder":"e.g. Describe your plan details ","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'description',
                'prompt'=>"please suggest subscription plan's description for the title as follows ##title##: for my business",
                'module'=>'plan',
                'field_json'=>'{"field":[{"label":"What is your plan title?","placeholder":"e.g. Pro Resller, Exclusive Access","field_type":"text_box","field_name":"title"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'name',
                'prompt'=>"give 10 catchy only name of Offer or discount Coupon for : ##keywords##",
                'module'=>'coupon',
                'field_json'=>'{"field":[{"label":"Seed words","placeholder":"e.g.coupon will provide you with a discount on your selected plan","field_type":"text_box","field_name":"keywords"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'meta_title',
                'prompt'=>"Write SEO meta title for:\n\n ##description## \n\nWebsite name is:\n ##title## \n\nSeed words:\n ##keywords## \n\n",
                'module'=>'seo',
                'field_json'=>'{"field":[{"label":"Website Name","placeholder":"e.g. Amazon, Google","field_type":"text_box","field_name":"title"},{"label":"Website Description","placeholder":"e.g. Describe what your website or business do","field_type":"textarea","field_name":"description"},{"label":"Keywords","placeholder":"e.g.  cloud services, databases","field_type":"text_box","field_name":"keywords"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'meta_description',
                'prompt'=>"Write SEO meta description for:\n\n ##description## \n\nWebsite name is:\n ##title## \n\nSeed words:\n ##keywords## \n\n",
                'module'=>'seo',
                'field_json'=>'{"field":[{"label":"Website Name","placeholder":"e.g. Amazon, Google","field_type":"text_box","field_name":"title"},{"label":"Website Description","placeholder":"e.g. Describe what your website or business do","field_type":"textarea","field_name":"description"},{"label":"Keywords","placeholder":"e.g.  cloud services, databases","field_type":"text_box","field_name":"keywords"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'cookie_title',
                'prompt'=>"please suggest me cookie title for the description as follows ##description## website which i can use in my website cookie",
                'module'=>'cookie',
                'field_json'=>'{"field":[{"label":"Website name or info","placeholder":"e.g. example website ","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'cookie_description',
                'prompt'=>"please suggest me Cookie description for this cookie title ##title## which i can use in my website cookie",
                'module'=>'cookie',
                'field_json'=>'{"field":[{"label":"Cookie Title ","placeholder":"e.g. example website ","field_type":"text_box","field_name":"title"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'strictly_cookie_title',
                'prompt'=>"please suggest me only Strictly Cookie Title for this ##description## website which i can use in my website cookie",
                'module'=>'cookie',
                'field_json'=>'{"field":[{"label":"Website name or info","placeholder":"e.g. example website ","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'strictly_cookie_description',
                'prompt'=>"please suggest me Strictly Cookie description for this Strictly cookie title ##title##  which i can use in my website cookie",
                'module'=>'cookie',
                'field_json'=>'{"field":[{"label":"Strictly Cookie Title ","placeholder":"e.g. example website ","field_type":"text_box","field_name":"title"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'more_information_description',
                'prompt'=>"I need assistance in crafting compelling content for my ##web_name## website's 'Contact Us' page of my website. The page should provide relevant information to users, encourage them to reach out for inquiries, support, and feedback, and reflect the unique value proposition of my business.",
                'module'=>'cookie',
                'field_json'=>'{"field":[{"label":"Websit Name","placeholder":"e.g. example website ","field_type":"text_box","field_name":"web_name"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'content',
                'prompt'=>"generate email template for ##type## in this format:\n\n Hello, {user_name} \n\n Your login detail for {app_name} is \n\n Username : {email} \n\n Password : {password} \n\n App Url : {app_url} \n\n Thanks \n\n {app_name} \n\n" ,
                'module'=>'email template',
                'field_json'=>'{"field":[{"label":"Email Type","placeholder":"e.g. new user,new client","field_type":"text_box","field_name":"type"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'content',
                'prompt'=>"create a notification massage for the event as follows ##topic## in this format: {project_name} Project is Created By {user_name}",
                'module'=>'notification template',
                'field_json'=>'{"field":[{"label":"Notification Message","placeholder":"e.g.brief explanation of the purpose or background of the notification","field_type":"textarea","field_name":"topic"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            //

            [
                'template_name'=>'contract_description',
                'prompt'=>"generate strictly one paragraph  description of ##title##",
                'module'=>'contract details',
                'field_json'=>'{"field":[{"label":"Contract Name","placeholder":"e.g. product return condition ","field_type":"textarea","field_name":"title"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'comment',
                'prompt'=>"generate strictly one line comment of ##title##",
                'module'=>'contract details',
                'field_json'=>'{"field":[{"label":"Contract Name","placeholder":"e.g. product return condition ","field_type":"textarea","field_name":"title"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'notes',
                'prompt'=>"generate short and valuable note for contract title '##name##'",
                'module'=>'contract details',
                'field_json'=>'{"field":[{"label":"Contract Name","placeholder":"e.g. product return condition ","field_type":"textarea","field_name":"name"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'title',
                'prompt'=>"provide personal notes name for following description,related to ##description##",
                'module'=>'notes',
                'field_json'=>'{"field":[{"label":"Description","placeholder":"e.g.  ","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'0',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'text',
                'prompt'=>"provide personal notes description for following title,related to ##title##",
                'module'=>'notes',
                'field_json'=>'{"field":[{"label":"Note Title","placeholder":"e.g. ","field_type":"text_box","field_name":"title"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'description',
                'prompt'=>"give short and valuable description of how much work on  for a ##task_name## in ##project_name##",
                'module'=>'timesheet',
                'field_json'=>'{"field":[{"label":"Project Name","placeholder":"Project Name","field_type":"text_box","field_name":"project_name"},{"label":"Task Name","placeholder":"Task Name","field_type":"text_box","field_name":"task_name"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'description',
                'prompt'=>"Write a short and innovative description for Project  which Topic is:\n ##title## \n\nnProject Information:\n ##description##.",
                'module'=>'project',
                'field_json'=>'{"field":[{"label":"Project Name","placeholder":"Project Name","field_type":"text_box","field_name":"title"},{"label":"Project Information","placeholder":"Project Information","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'comment',
                'prompt'=>"Generate tiny and valuable comment for a project in an ##project_name##, specifically related to ##instruction##.",
                'module'=>'task show',
                'field_json'=>'{"field":[{"label":"Project name","placeholder":"e.g.","field_type":"text_box","field_name":"project_name"},{"label":"Task Instruction","placeholder":"e.g.","field_type":"textarea","field_name":"instruction"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'description',
                'prompt'=>"generate description of bug for a ##bug_name##  in ##project_name##",
                'module'=>'bug',
                'field_json'=>'{"field":[{"label":"Project name","placeholder":"e.g.","field_type":"text_box","field_name":"project_name"},{"label":"Bug Name","placeholder":"e.g.","field_type":"text_box","field_name":"bug_name"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'comment',
                'prompt'=>"generate short and valuable comment of bug for a ##bug_name## in ##project_name##",
                'module'=>'bug show',
                'field_json'=>'{"field":[{"label":"Project name","placeholder":"e.g.","field_type":"text_box","field_name":"project_name"},{"label":"Bug Name","placeholder":"e.g.","field_type":"text_box","field_name":"bug_name"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'summary',
                'prompt'=>"Generate a strictly one line  and valuable milestone summary for a  ##project_name##, specifically related to ##milestone_name##.",
                'module'=>'milestone',
                'field_json'=>'{"field":[{"label":"Project name","placeholder":"e.g.","field_type":"text_box","field_name":"project_name"},{"label":"Milestone Name","placeholder":"e.g.","field_type":"text_box","field_name":"milestone_name"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'description',
                'prompt'=>"Generate short task description for a project in an ##project_name##, specifically related to ##instruction##.",
                'module'=>'task',
                'field_json'=>'{"field":[{"label":"Project name","placeholder":"e.g.","field_type":"text_box","field_name":"project_name"},{"label":"Task Instruction","placeholder":"e.g.","field_type":"textarea","field_name":"instruction"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],
            [
                'template_name'=>'name',
                'prompt'=>"Generate a workspace name for following description  ##description##",
                'module'=>'workspace',
                'field_json'=>'{"field":[{"label":"Workspace Descrioption","placeholder":"e.g.","field_type":"textarea","field_name":"description"}]}',
                'is_tone'=>'1',
                "created_at" => date('Y-m-d H:i:s'),
                "updated_at" => date('Y-m-d H:i:s'),
            ],

        ];
        
        Template::insert($template);
    }
}

